/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: SercosIII_SlNRT_Public.h 52411 2015-03-20 13:24:41Z DenisJ            $

   Description:
    SERCOSIII Slave NRT Task

    Includes following functions:

   Changes:

     Date          Description
     ---------------------------------------------------------------------------
     2009-08-05    Created
*******************************************************************************/
/**
 * @file SercosIII_SlNRT_Public.h
 *  SercosIII_Sl NRT - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 *
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__TLR_PACKED_PRE</code>
 * and <code>__TLR_PACKED_POST</code> have to be added with the structural definition
 * in addition.
 */

#ifndef _SERCOSIII_SLNRT_PUBLIC_H_
#define _SERCOSIII_SLNRT_PUBLIC_H_

#define SIII_SL_NRT_QUEUE_NAME  "QUE_S3_SL_NRT"

#define SIII_SL_NRT_CMD_ENABLE_PROMISC_REQ                0x00006620
#define SIII_SL_NRT_CMD_ENABLE_PROMISC_CNF                0x00006621

#define SIII_SL_NRT_CMD_DISABLE_PROMISC_REQ               0x00006622
#define SIII_SL_NRT_CMD_DISABLE_PROMISC_CNF               0x00006623

/* following request is used by COM task */
#define SIII_SL_NRT_CMD_RESET_MAC_TABLE_REQ               0x00006640
#define SIII_SL_NRT_CMD_RESET_MAC_TABLE_CNF               0x00006641

#define SIII_SL_NRT_CMD_CHECK_IP_PARAMETERS_IND           0x00006680
#define SIII_SL_NRT_CMD_CHECK_IP_PARAMETERS_RES           0x00006681

#define SIII_SL_NRT_CMD_INIT_IP_PARAMETERS_REQ            0x00006682
#define SIII_SL_NRT_CMD_INIT_IP_PARAMETERS_CNF            0x00006683

#define SIII_SL_NRT_CMD_ACTIVATE_IP_PARAMETERS_IND        0x00006684
#define SIII_SL_NRT_CMD_ACTIVATE_IP_PARAMETERS_RES        0x00006685

#define SIII_SL_NRT_SET_CHECK_IP_PARAM_QUEUE_REQ          0x00006690
#define SIII_SL_NRT_SET_CHECK_IP_PARAM_QUEUE_CNF          0x00006691

#define SIII_SL_NRT_CLR_CHECK_IP_PARAM_QUEUE_REQ          0x00006692
#define SIII_SL_NRT_CLR_CHECK_IP_PARAM_QUEUE_CNF          0x00006693

/******************************************************************************
 * Packet:  SIII_SL_NRT_CMD_INIT_IP_PARAMETERS_REQ/SIII_SL_NRT_CMD_INIT_IP_PARAMETERS_CNF
 */

/* request packet */

typedef __TLR_PACKED_PRE struct SIII_SL_NRT_INIT_IP_PARAMETERS_REQ_DATA_Ttag
{
  /** Parameters for TCP/IP-Stack */
  TLR_UINT32      ulTcpFlags;
  /** IP Address (IP is little-endian formatted) */
  TLR_UINT32      ulIpAddr;
  /** Netmask (little endian formatted) */
  TLR_UINT32      ulNetMask;
  /** Gateway address (little endian formatted) */
  TLR_UINT32      ulGateway;
  TLR_UINT8 bHostNameLength;
  TLR_UINT8 abHostName[255];
} __TLR_PACKED_POST SIII_SL_NRT_INIT_IP_PARAMETERS_REQ_REQ_DATA_T;

typedef struct SIII_SL_NRT_INIT_IP_PARAMETERS_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
  SIII_SL_NRT_INIT_IP_PARAMETERS_REQ_REQ_DATA_T tData;
} SIII_SL_NRT_INIT_IP_PARAMETERS_REQ_T;

/* confirmation packet */

typedef struct SIII_SL_NRT_INIT_IP_PARAMETERS_CNF_Ttag
{
  TLR_PACKET_HEADER_T                           tHead;
} SIII_SL_NRT_INIT_IP_PARAMETERS_CNF_T;

/******************************************************************************
 * Packet:  SIII_SL_NRT_CMD_CHECK_IP_PARAMETERS_REQ/SIII_SL_NRT_CMD_CHECK_IP_PARAMETERS_CNF
 */

/* request packet */

typedef __TLR_PACKED_PRE struct SIII_SL_NRT_CHECK_IP_PARAMETERS_IND_DATA_Ttag
{
  /** Parameters for TCP/IP-Stack */
  TLR_UINT32      ulTcpFlags;
  /** IP Address (IP is little-endian formatted) */
  TLR_UINT32      ulIpAddr;
  /** Netmask (little endian formatted) */
  TLR_UINT32      ulNetMask;
  /** Gateway address (little endian formatted) */
  TLR_UINT32      ulGateway;
  TLR_UINT8       bHostNameLength;
  TLR_UINT8       abHostName[255];
} __TLR_PACKED_POST SIII_SL_NRT_CHECK_IP_PARAMETERS_IND_DATA_T;

typedef struct SIII_SL_NRT_CHECK_IP_PARAMETERS_IND_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
  SIII_SL_NRT_CHECK_IP_PARAMETERS_IND_DATA_T      tData;
} SIII_SL_NRT_CHECK_IP_PARAMETERS_IND_T;

/* confirmation packet */

typedef struct SIII_SL_NRT_CHECK_IP_PARAMETERS_RES_Ttag
{
  TLR_PACKET_HEADER_T                             tHead;
} SIII_SL_NRT_CHECK_IP_PARAMETERS_RES_T;

/******************************************************************************
 * Packet:  SIII_SL_NRT_CMD_ENABLE_PROMISC_REQ/SIII_SL_NRT_CMD_ENABLE_PROMISC_CNF
 */

/* request packet */

typedef struct SIII_SL_NRT_CMD_ENABLE_PROMISC_REQ_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
} SIII_SL_NRT_CMD_ENABLE_PROMISC_REQ_T;

/* confirmation packet */

typedef struct SIII_SL_NRT_CMD_ENABLE_PROMISC_CNF_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
} SIII_SL_NRT_CMD_ENABLE_PROMISC_CNF_T;

/******************************************************************************
 * Packet:  SIII_SL_NRT_CMD_DISABLE_PROMISC_REQ/SIII_SL_NRT_CMD_DISABLE_PROMISC_CNF
 */

/* request packet */

typedef struct SIII_SL_NRT_CMD_DISABLE_PROMISC_REQ_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
} SIII_SL_NRT_CMD_DISABLE_PROMISC_REQ_T;

/* confirmation packet */

typedef struct SIII_SL_NRT_CMD_DISABLE_PROMISC_CNF_Ttag
{
  TLR_PACKET_HEADER_T         tHead;
} SIII_SL_NRT_CMD_DISABLE_PROMISC_CNF_T;


#endif /* _SERCOSIII_SLNRT_PUBLIC_H_ */
